///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MaxLogEntries 100

int LogNumber;

char LJobType[1024];
char LDataBase[1024];
char LFileName[1024];
char LResult[1024];

DWORD LStartTime;
DWORD LStopTime;

DWORD LStartDate;
DWORD LStopDate;

DWORD LByteCount;

_NDBSTable JobLog;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CreateLoggingFile(void)
{
    char *ColumbName = NULL;

	if(!InitializeTable(&JobLog, 100, MaxLogEntries + 1, "JobLog", 6))
        return FALSE;

    ColumbName = "JobType";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "DataBase";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "FileName";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "Result";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "StartDate";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "StopDate";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "StartTime";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "StopTime";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    ColumbName = "ByteCount";
    AddColumb(&JobLog, ColumbName, strlen(ColumbName));

    if(WriteNDBSFile(&JobLog, JobLogDB) == FALSE)
        return FALSE;

    FreeTable(&JobLog);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL InitilizeLogging(void)
{
     if(!ReadNDBSFile(&JobLog, JobLogDB))
    {
        if(!CreateLoggingFile())
        {
            return FALSE;
        }
    }

    if(!ReadNDBSFile(&JobLog, JobLogDB))
        return FALSE;

    LogNumber = GetMostRows(&JobLog);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL UninitilizeLogging(void)
{
    if(!WriteNDBSFile(&JobLog, JobLogDB))
    {
        return FALSE;
    }

    FreeTable(&JobLog);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL LoadJobLogDBIntoDialog()
{
    int LocalLoop = 0;

    char LocalBuffer[256];
    DWORD DWBuffer = 0;

    SYSTEMTIME ST;

    GetSystemTime(&ST);

    char Time[64];
    char Date[64];

    int Year, Month, Day;
    int Hour, Minute, Second;

    while(LocalLoop < LogNumber)
    {
        //----------------------------------------------------------------------------------------------------

        DWBuffer = 0;
        RetreiveDataByColumbName(&JobLog, "StartTime", LocalLoop, (char *) &DWBuffer);
        LongToTime(DWBuffer, &Hour, &Minute, &Second);

        DWBuffer = 0;
        RetreiveDataByColumbName(&JobLog, "StartDate", LocalLoop, (char *) &DWBuffer);
        LongToDate(DWBuffer, &Year, &Month, &Day);

        ST.wHour   = Hour;
        ST.wMinute = Minute;
        ST.wSecond = Second;
        ST.wDay    = Day;
        ST.wMonth  = Month;
        ST.wYear   = Year;

        GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &ST, NULL, Time, 64);
        GetDateFormat(NULL, NULL, &ST, "MM-dd-yyyy", Date, 64);

        sprintf(LocalBuffer, "%s - %s", Time, Date);
        VLD.LVItem.pszText  = LocalBuffer;
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 0;
        ListView_InsertItem(VLD.ListView_hWnd, &VLD.LVItem);

        //----------------------------------------------------------------------------------------------------

        DWBuffer = 0;
        RetreiveDataByColumbName(&JobLog, "StopTime", LocalLoop, (char *) &DWBuffer);
        LongToTime(DWBuffer, &Hour, &Minute, &Second);

        DWBuffer = 0;
        RetreiveDataByColumbName(&JobLog, "StopDate", LocalLoop, (char *) &DWBuffer);
        LongToDate(DWBuffer, &Year, &Month, &Day);

        ST.wHour   = Hour;
        ST.wMinute = Minute;
        ST.wSecond = Second;
        ST.wDay    = Day;
        ST.wMonth  = Month;
        ST.wYear   = Year;

        GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &ST, NULL, Time, 64);
        GetDateFormat(NULL, NULL, &ST, "MM-dd-yyyy", Date, 64);

        sprintf(LocalBuffer, "%s - %s", Time, Date);
        VLD.LVItem.pszText  = LocalBuffer;
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 1;
        ListView_SetItem(VLD.ListView_hWnd, &VLD.LVItem);

        //----------------------------------------------------------------------------------------------------

        ClearMem(LocalBuffer, 256);
        RetreiveDataByColumbName(&JobLog, "JobType", LocalLoop, LocalBuffer);
        VLD.LVItem.pszText  = LocalBuffer;
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 2;
        ListView_SetItem(VLD.ListView_hWnd, &VLD.LVItem);

        //----------------------------------------------------------------------------------------------------

        ClearMem(LocalBuffer, 256);
        RetreiveDataByColumbName(&JobLog, "DataBase", LocalLoop, LocalBuffer);
        VLD.LVItem.pszText  = LocalBuffer;
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 3;
        ListView_SetItem(VLD.ListView_hWnd, &VLD.LVItem);

        //----------------------------------------------------------------------------------------------------

        ClearMem(LocalBuffer, 256);
        RetreiveDataByColumbName(&JobLog, "FileName", LocalLoop, LocalBuffer);
        VLD.LVItem.pszText  = LocalBuffer;
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 4;
        ListView_SetItem(VLD.ListView_hWnd, &VLD.LVItem);

        //----------------------------------------------------------------------------------------------------

        DWBuffer = 0;
        RetreiveDataByColumbName(&JobLog, "ByteCount", LocalLoop, (char *) &DWBuffer);
        VLD.LVItem.pszText  = LongChar(DWBuffer);
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 5;
        ListView_SetItem(VLD.ListView_hWnd, &VLD.LVItem);

        //----------------------------------------------------------------------------------------------------

        ClearMem(LocalBuffer, 256);
        RetreiveDataByColumbName(&JobLog, "Result", LocalLoop, LocalBuffer);
        VLD.LVItem.pszText  = LocalBuffer;
        VLD.LVItem.mask     = LVIF_TEXT;
        VLD.LVItem.iSubItem = 6;
        ListView_SetItem(VLD.ListView_hWnd, &VLD.LVItem);

		LocalLoop++;;
    }

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL AddToJobLogDB(void)
{
    if(LogNumber == (MaxLogEntries - 1))
    {
        DeleteCellByColumbNameAndRowPosition(&JobLog, "JobType", 0);
        DeleteCellByColumbNameAndRowPosition(&JobLog, "DataBase", 0);
        DeleteCellByColumbNameAndRowPosition(&JobLog, "FileName", 0);
        DeleteCellByColumbNameAndRowPosition(&JobLog, "Result", 0);

        DeleteCellByColumbNameAndRowPosition(&JobLog, "StartTime", 0);
        DeleteCellByColumbNameAndRowPosition(&JobLog, "StopTime", 0);

        DeleteCellByColumbNameAndRowPosition(&JobLog, "StartDate", 0);
        DeleteCellByColumbNameAndRowPosition(&JobLog, "StopDate", 0);

        DeleteCellByColumbNameAndRowPosition(&JobLog, "ByteCount", 0);

        LogNumber--;
    }

    AddEntryByColumbName(&JobLog, "JobType", LJobType, strlen(LJobType));
    AddEntryByColumbName(&JobLog, "DataBase", LDataBase, strlen(LDataBase));
    AddEntryByColumbName(&JobLog, "FileName", LFileName, strlen(LFileName));
    AddEntryByColumbName(&JobLog, "Result", LResult, strlen(LResult));

    AddEntryByColumbName(&JobLog, "StartTime", (char *)&LStartTime, sizeof(DWORD));
    AddEntryByColumbName(&JobLog, "StopTime", (char *)&LStopTime, sizeof(DWORD));

    AddEntryByColumbName(&JobLog, "StartDate", (char *)&LStartDate, sizeof(DWORD));
    AddEntryByColumbName(&JobLog, "StopDate", (char *)&LStopDate, sizeof(DWORD));

    AddEntryByColumbName(&JobLog, "ByteCount", (char *)&LByteCount, sizeof(DWORD));

    LogNumber++;

/*
    MessageBox(NULL, IntChar(LogNumber), "LogNumber", 0);

    MessageBox(NULL, LJobType,  "LJobType",  0);
    MessageBox(NULL, LDataBase, "LDataBase", 0);
    MessageBox(NULL, LFileName, "LFileName", 0);
    MessageBox(NULL, LResult,   "LResult",   0);

    MessageBox(NULL, IntChar(LStartTime), "LStartTime", 0);
    MessageBox(NULL, IntChar(LStopTime),  "LStopTime",  0);
    MessageBox(NULL, IntChar(LByteCount), "LByteCount", 0);
*/
    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

